IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Turno_Validar_Producto') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Turno_Validar_Producto
END
GO


CREATE FUNCTION [dbo].[CF_Turno_Validar_Producto](@pId_Cliente INT, @pId_Turno BIGINT, @pId_Sector_Turno INT )
RETURNS VARCHAR(14)
AS
BEGIN


DECLARE @Respuesta				VARCHAR(14) 
DECLARE @Fecha					DATETIME
DECLARE @Id_Recurso				INT 
DECLARE @Id_Recurso_Horario		INT 
DECLARE @Flag_Producto_Valida	INT
DECLARE @Habilitado				INT
DECLARE @Id_Sector				SMALLINT
DECLARE @Id_Producto			VARCHAR(50)
DECLARE @Id_Sector_Deseado		SMALLINT

DECLARE @Dias_Gracia			INT

--===========================================================================================
IF EXISTS ( SELECT * FROM sysobjects 
			WHERE 
			id = object_id(N'dbo.CF_Turno_Validar_Producto_') 
			AND type = 'FN')
BEGIN
	/*Si existe la funcion personalizada CF_Turno_Validar_ utiliza esa*/
    SET @Respuesta = (dbo.CF_Turno_Validar_Producto_(@pId_Cliente, @pId_Turno,@pId_Sector_Turno))
    RETURN ISNULL(@Respuesta, '')
END

--===========================================================================================
SELECT	@Id_Recurso = ISNULL(Id_Recurso, 0),
		@Fecha		= Fecha,
		@Id_Recurso_Horario = ISNULL(Id_Recurso_Horario, 0)
FROM CRM_Turnos 
WHERE 
Id_Turno = @pId_Turno

--===========================================================================================
SELECT @Id_Sector_Deseado = ISNULL(Id_Sector, 0)
FROM Empresas_Sedes_Sec_Recursos
WHERE
Id_Recurso = @Id_Recurso

--===========================================================================================
SET @Habilitado=0
IF(@Id_Sector_Deseado > 0) 
BEGIN

	/*VALIDO EL PRODUCTO DEL SECTOR TURNO Empresas_Sedes_Sec_Turnos */
	SET @Flag_Producto_Valida = ISNULL((SELECT  MAX(1) FROM Empresas_Sedes_Sec_Turnos WHERE Id_Sector=@pId_Sector_Turno),0)
	IF(@Flag_Producto_Valida=1)
	BEGIN

		
		DECLARE cur_Valida_Turno CURSOR FOR
		SELECT ISNULL(Id_producto, '')
		FROM  Empresas_Sedes_Sec_Turnos
		WHERE
		Id_Sector = @pId_Sector_Turno


		OPEN cur_Valida_Turno
		FETCH NEXT FROM cur_Valida_Turno INTO @Id_Producto
		WHILE @@FETCH_STATUS = 0
		BEGIN

		SET @Habilitado= dbo.CF_Item_Paid(@pId_Cliente, @Id_Producto, @Fecha) 

			IF(@Habilitado=1)
			BEGIN
				SET  @Respuesta = '' 
				BREAK
			END

		FETCH NEXT FROM cur_Valida_Turno INTO @Id_Producto
		END
		CLOSE cur_Valida_Turno
		DEALLOCATE cur_Valida_Turno


	END 



	/*VALIDAMOS EL PRODUCTO DEL RECURSO HORARIO*/
	
	SET @Flag_Producto_Valida = ISNULL((SELECT  MAX(1) FROM Empresas_Sedes_Sec_Recuros_Horarios WHERE Id_Recurso=@Id_Recurso),0)
	IF(@Flag_Producto_Valida=1)
	BEGIN

		
		DECLARE cur_Valida_Turno CURSOR FOR
		SELECT ISNULL(Id_producto, '')
		FROM  Empresas_Sedes_Sec_Recuros_Horarios
		WHERE
		Id_Recurso = @Id_Recurso


		OPEN cur_Valida_Turno
		FETCH NEXT FROM cur_Valida_Turno INTO @Id_Producto
		WHILE @@FETCH_STATUS = 0
		BEGIN

		SET @Habilitado= dbo.CF_Item_Paid(@pId_Cliente, @Id_Producto, @Fecha) 

			IF(@Habilitado=1)
			BEGIN
				SET  @Respuesta = '' 
				RETURN @Respuesta
			END

		FETCH NEXT FROM cur_Valida_Turno INTO @Id_Producto
		END
		CLOSE cur_Valida_Turno
		DEALLOCATE cur_Valida_Turno


	END 
	

	
		/*VALIDO EL PRODUCTO DEL SECTOR PRODUCTO Empresas_Sedes_Sectores_Prod */
	SET @Flag_Producto_Valida = ISNULL((SELECT  MAX(1) FROM Empresas_Sedes_Sectores_Prod WHERE Id_Sector=@Id_Sector_Deseado),0)
	IF(@Flag_Producto_Valida=1)
	BEGIN
		
		DECLARE cur_Valida_Turno CURSOR FOR
		SELECT ISNULL(Id_producto, '')
		FROM  Empresas_Sedes_Sectores_Prod
		WHERE
		Id_Sector = @Id_Sector_Deseado


		OPEN cur_Valida_Turno
		FETCH NEXT FROM cur_Valida_Turno INTO @Id_Producto
		WHILE @@FETCH_STATUS = 0
		BEGIN

		SET @Dias_Gracia= ISNULL((SELECT ISNULL(Dias_Gracia,0) FROM Empresas_Sedes_Sectores_Prod 
							WHERE Id_Sector=@Id_Sector_Deseado AND Id_Producto=@Id_Producto),0)

		SET @Habilitado= dbo.CF_Turno_Item_Paid(@pId_Cliente, @Id_Producto, @Fecha,@Dias_Gracia) 

			IF(@Habilitado=1)
			BEGIN
				SET  @Respuesta = '' 
				BREAK
			END

		FETCH NEXT FROM cur_Valida_Turno INTO @Id_Producto
		END
		CLOSE cur_Valida_Turno
		DEALLOCATE cur_Valida_Turno


	END 


END

	IF(@Habilitado=0)
	BEGIN
		IF (@pId_Sector_Turno!=0)	
			BEGIN
				SET @Id_Producto= dbo.CF_Turno_Producto_Cobrar(@Id_Recurso_Horario,@pId_Sector_Turno,@Id_Recurso)
			END 
			
		IF (@Id_Producto ='' AND @Id_Sector_Deseado!=0 )	
			BEGIN
				SET @Id_Producto= dbo.CF_Turno_Producto_Cobrar(@Id_Recurso_Horario,@Id_Sector_Deseado,@Id_Recurso)
			END
			
		SET @Respuesta= ISNULL(@Id_Producto,'')
	END

RETURN ISNULL(@Respuesta, '')
END